from math import*
from typing import Union

import numpy as np
from numpy.core._multiarray_umath import ndarray

import matplotlib.pyplot as plt

x_list = []
y_list = []

for j in range(10):
    n = 12 * j
    T1 = np.linspace(0, 4.4816, 100)
    T2 = np.linspace(4.4816, 6, 100)
    T3 = np.linspace(6, 10.4816, 100)
    T4 = np.linspace(10.4816, 12, 100)
    for i in range(len(T1)):
        T1[i] = n + T1[i]
        T2[i] = n + T2[i]
        T3[i] = n + T3[i]
        T4[i] = n + T4[i]
    t1 = []
    t2 = []
    t3 = []
    t4 = []
    for i in range(len(T1)-1):
        t = T1[i+1] - n
        t1.append(t)
    for i in range(len(T2) - 1):
        t = T2[i + 1] - T1[-1]
        t2.append(t)
    for i in range(len(T3) - 1):
        t = T3[i + 1] - T2[-1]
        t3.append(t)
    for i in range(len(T4) - 1):
        t = T4[i + 1] - T3[-1]
        t4.append(t)
    L = 30.6
    R = 3.3
    h = 4.4
    w = 7.3
    vc = (5 * (2 * L + 2 * pi * R)) / 60
    w_b = 8 * pi / 60
    t0 = 0
    s_t = vc * t0
    rpx = R + h
    rpy = s_t - 0.5 * (L - w)
    rpr = sqrt((rpx) ** 2 + (rpy) ** 2)
    d_rpx = 0
    d_rpy = vc
    d_rpr = (1 / rpr) * (rpx * d_rpx + rpy * d_rpy)
    dp_p = ((rpx * d_rpy) - (rpy * d_rpx)) / (rpr ** 2)
    d_theta = w_b + dp_p
    p_p = atan(rpy / rpx)
    phi = w_b * T1[i]
    theta = phi + p_p
    vpr_er = d_rpr
    vpr_eo = rpr * d_theta
    vpr0 = sqrt((vpr_er ** 2) + (vpr_eo ** 2))
    v_angle = atan(vpr_eo / vpr_er)
    dd_rpx = 0
    dd_rpy = 0
    dd_rpr = ((1 / rpr) * (rpx * dd_rpx + d_rpx ** 2 + rpy * dd_rpy + d_rpy ** 2)) - (
            (1 / (rpr ** 3)) * (rpx * d_rpx + rpr * d_rpr) ** 2)
    dd_theta = ((rpx * dd_rpy - rpy * dd_rpx) / (rpr ** 2)) - 2 * ((rpx * d_rpy - rpy * d_rpx) / (rpr ** 4)) * (
            rpx * d_rpx + rpy * d_rpy)
    apr_er = dd_rpr - rpr * (d_theta ** 2)
    apr_eo = rpr * dd_theta + 2 * d_rpr * d_theta
    apr0 = sqrt(apr_er ** 2 + apr_eo ** 2)
    a_angle = atan(apr_eo / apr_er)
    x_list1 = []
    y_list1 = []
    for i in range(len(t1)):
        t = t1[i]
        s_t = vc * t
        rpx = R + h
        rpy = s_t - 0.5 * (L - w)
        rpr = sqrt((rpx) ** 2 + (rpy) ** 2)
        d_rpx = 0
        d_rpy = vc
        d_rpr = (1 / rpr) * (rpx * d_rpx + rpy * d_rpy)
        dp_p = ((rpx * d_rpy) - (rpy * d_rpx)) / (rpr ** 2)
        d_theta = w_b + dp_p
        p_p = atan(rpy / rpx)
        phi = w_b * T1[i]
        theta = phi + p_p
        vpr_er = d_rpr
        vpr_eo = rpr * d_theta
        vpr = sqrt((vpr_er**2) + (vpr_eo**2))
        v_angle = atan(vpr_eo/vpr_er)
        dd_rpx = 0
        dd_rpy = 0
        dd_rpr = ((1 / rpr) * (rpx * dd_rpx + d_rpx ** 2 + rpy * dd_rpy + d_rpy ** 2)) - (
                    (1 / (rpr ** 3)) * (rpx * d_rpx + rpr * d_rpr) ** 2)
        dd_theta = ((rpx * dd_rpy - rpy * dd_rpx) / (rpr ** 2)) - 2 * ((rpx * d_rpy - rpy * d_rpx) / (rpr ** 4)) * (
                    rpx * d_rpx + rpy * d_rpy)
        apr_er = dd_rpr - rpr * (d_theta ** 2)
        apr_eo = rpr * dd_theta + 2 * d_rpr * d_theta
        apr = sqrt(apr_er ** 2 + apr_eo ** 2)
        a_angle = atan(apr_eo / apr_er)
        x_list1.append(T1[i+1])
        y_list1.append(apr)
    x_list2 = []
    y_list2 = []
    for i in range(len(t2)):
        t = t2[i]
        s_t = vc * t
        B_t = (vc / R) * t
        rpx = (R + h) * cos(B_t) - 0.5 * w * sin(B_t)
        rpy = 0.5 * L + (R + h) * sin(B_t) + 0.5 * w * cos(B_t)
        rpr = sqrt((rpx) ** 2 + (rpy) ** 2)
        d_rpx = -((R + h) * sin(B_t) + 0.5 * w * cos(B_t)) * (vc / R)
        d_rpy = ((R + h) * cos(B_t) - 0.5 * w * sin(B_t)) * (vc / R)
        d_rpr = (1 / rpr) * (rpx * d_rpx + rpy * d_rpy)
        dp_p = ((rpx * d_rpy) - (rpy * d_rpx)) / (rpr ** 2)
        d_theta = w_b + dp_p
        p_p = atan(rpy / rpx)
        phi = w_b * T1[i]
        theta = phi + p_p
        vpr_er = d_rpr
        vpr_eo = rpr * d_theta
        vpr = sqrt((vpr_er ** 2) + (vpr_eo ** 2))
        v_angle = atan(vpr_eo / vpr_er)
        dd_rpx = (0.5*w*sin(B_t) - (R+h)*cos(B_t)) * ((vc/R)**2)
        dd_rpy = -(0.5 * w * cos(B_t) + (R + h) * sin(B_t)) * ((vc / R) ** 2)
        dd1 = (1/rpr) * (rpx * dd_rpx + d_rpx**2 + rpy * dd_rpy + d_rpy**2 )
        dd2 = (1/rpr**3) * (rpx * d_rpx + rpy * d_rpy)**2
        dd_rpr = dd1-dd2
        dd_theta = ((rpx*dd_rpy - rpy*dd_rpx)/(rpr**2)) - 2 * ((rpx*d_rpy - rpy*d_rpx)/(rpr**4)) * (rpx * d_rpx + rpy * d_rpy)
        apr_er = dd_rpr - rpr * (d_theta**2)
        apr_eo = rpr * dd_theta + 2 * d_rpr * d_theta
        apr = sqrt(apr_er**2 + apr_eo**2)
        a_angle = atan(apr_eo / apr_er)
        print(T2[i+1], apr_er, apr_eo, apr, a_angle)
        x_list2.append(T2[i+1])
        y_list2.append(apr)
    x_list3 = []
    y_list3 = []
    for i in range(len(t3)):
        t = t3[i]
        s_t = vc * t
        rpx = R + h
        rpy = s_t - 0.5 * (L - w)
        rpr = sqrt((rpx) ** 2 + (rpy) ** 2)
        d_rpx = 0
        d_rpy = vc
        d_rpr = (1 / rpr) * (rpx * d_rpx + rpy * d_rpy)
        dp_p = ((rpx * d_rpy) - (rpy * d_rpx)) / (rpr ** 2)
        d_theta = w_b + dp_p
        p_p = atan(rpy / rpx)
        phi = w_b * T1[i]
        theta = phi + p_p
        vpr_er = d_rpr
        vpr_eo = rpr * d_theta
        vpr = sqrt((vpr_er ** 2) + (vpr_eo ** 2))
        v_angle = atan(vpr_eo / vpr_er)
        dd_rpx = 0
        dd_rpy = 0
        dd_rpr = ((1 / rpr) * (rpx * dd_rpx + d_rpx ** 2 + rpy * dd_rpy + d_rpy ** 2)) - (
                (1 / (rpr ** 3)) * (rpx * d_rpx + rpr * d_rpr) ** 2)
        dd_theta = ((rpx * dd_rpy - rpy * dd_rpx) / (rpr ** 2)) - 2 * ((rpx * d_rpy - rpy * d_rpx) / (rpr ** 4)) * (
                rpx * d_rpx + rpy * d_rpy)
        apr_er = dd_rpr - rpr * (d_theta ** 2)
        apr_eo = rpr * dd_theta + 2 * d_rpr * d_theta
        apr = sqrt(apr_er ** 2 + apr_eo ** 2)
        a_angle = atan(apr_eo / apr_er)
        x_list3.append(T3[i+1])
        y_list3.append(apr)
    x_list4 = []
    y_list4 = []
    for i in range(len(t4)):
        t = t4[i]
        s_t = vc * t
        B_t = (vc / R) * t
        rpx = (R + h) * cos(B_t) - 0.5 * w * sin(B_t)
        rpy = 0.5 * L + (R + h) * sin(B_t) + 0.5 * w * cos(B_t)
        rpr = sqrt((rpx) ** 2 + (rpy) ** 2)
        d_rpx = -((R + h) * sin(B_t) + 0.5 * w * cos(B_t)) * (vc / R)
        d_rpy = ((R + h) * cos(B_t) - 0.5 * w * sin(B_t)) * (vc / R)
        d_rpr = (1 / rpr) * (rpx * d_rpx + rpy * d_rpy)
        dp_p = ((rpx * d_rpy) - (rpy * d_rpx)) / (rpr ** 2)
        d_theta = w_b + dp_p
        p_p = atan(rpy / rpx)
        phi = w_b * T1[i]
        theta = phi + p_p
        vpr_er = d_rpr
        vpr_eo = rpr * d_theta
        vpr = sqrt((vpr_er ** 2) + (vpr_eo ** 2))
        v_angle = atan(vpr_eo / vpr_er)
        dd_rpx = (0.5 * w * sin(B_t) - (R + h) * cos(B_t)) * ((vc / R) ** 2)
        dd_rpy = -(0.5 * w * cos(B_t) + (R + h) * sin(B_t)) * ((vc / R) ** 2)
        dd1 = (1 / rpr) * (rpx * dd_rpx + d_rpx ** 2 + rpy * dd_rpy + d_rpy ** 2)
        dd2 = (1 / rpr ** 3) * (rpx * d_rpx + rpy * d_rpy) ** 2
        dd_rpr = dd1 - dd2
        dt1 = (rpx * dd_rpy - rpy * dd_rpx)/(rpr**2)
        dt2 = ((rpx * d_rpy - rpy * d_rpx) * (rpx * d_rpx + rpy * d_rpy)) / (rpr**4)
        dd_theta = dt1 - 2*dt2
        apr_er = dd_rpr - rpr * (d_theta ** 2)
        apr_eo = rpr * dd_theta + 2 * d_rpr * d_theta
        apr = sqrt(apr_er ** 2 + apr_eo ** 2)
        a_angle = atan(apr_eo / apr_er)
        print(T4[i + 1], apr_er, apr_eo, apr, a_angle)
        x_list4.append(T4[i+1])
        y_list4.append(apr)
    for i in range(len(x_list1)):
        x_list.append(x_list1[i])
        y_list.append(y_list1[i])
    for i in range(len(x_list2)):
        x_list.append(x_list2[i])
        y_list.append(y_list2[i])
    for i in range(len(x_list3)):
        x_list.append(x_list3[i])
        y_list.append(y_list3[i])
    for i in range(len(x_list4)):
        x_list.append(x_list4[i])
        y_list.append(y_list4[i])

x_list.insert(0, t0)
y_list.insert(0, apr0)
plt.plot(x_list,y_list,'r-')
plt.title('Task 5')
plt.xlabel('Time')
plt.ylabel('Apr')
plt.axis([0, 120, 0, 60])
plt.show()